program SimpleCopyFile;

{$APPTYPE CONSOLE}

uses
  System,
  SysUtils;

var
    FromF, ToF: file;               // File handlers
    NumRead, NumWritten: Integer;   // Read / Write counter
    Buf: array[1..2048] of Char;    // Read / Write bufer

begin
 WriteLn(' =============================================== ');
 WriteLn('        SIMPLE COPY FILE UTILITY ');

 if ParamCount > 1
 then begin
   { TODO -oUser -cConsole Main : Insert code here }
   // Open input file
   Assign(FromF, ParamStr(1));
   // Record size = 1
   Reset(FromF, 1);

   // Open output file
   Assign(ToF, ParamStr(2));
   // Record size = 1
   Rewrite(ToF, 1);

   // Report to Screen
   WriteLn('Copying ', FileSize(FromF), ' bytes...');

   // Copy file
   repeat
       BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
       BlockWrite(ToF,  Buf, NumRead, NumWritten);
   until (NumRead = 0) or (NumWritten <> NumRead);

   // Report
   WriteLn('Source  file : ', ParamStr(1));
   WriteLn('Target  file : ', ParamStr(2));

   // Close file
   Close(FromF);
   Close(ToF);
 end
 else begin
    WriteLn(' USE format: ');
    WriteLn(' SimpleCopyFile.exe SourceFileName TargetFileName');
 end;
 WriteLn(' =============================================== ');
 Write  (' Press Enter key to continue ... ');
 ReadLn;
end.
